using System;
using System.ComponentModel;
using System.Windows.Forms;

namespace Precisely_single
{
    internal partial class MainForm : Form
    {
        private void ReadyHandler(object sender, EventArgs e)
        {
            toolStripStatusLabel.Text = "ready";
        }

        public MainForm()
        {
            InitializeComponent();
            foreach (Control control in Controls)
                control.GotFocus += ReadyHandler;
        }

        private void processString(string number)
        {
            number = number.Trim();
            string message;
            if (number.Length != 0)
            {
                int lastIndex = number.Length - 1;
                char lastChar = number[lastIndex];
                bool fiveDown = false;
                if (lastChar == '+' || lastChar == '-')
                {
                    number = number.Remove(lastIndex);
                    if (lastChar == '-') fiveDown = true;
                }
                if (Precise.IsStdDecimal(number))
                {
                    try
                    {
                        number = Precise.RoundOff(number, fiveDown);
                        if (checkBox.Checked) Clipboard.SetText(number);
                        textBox.Text = number;
                        return;
                    }
                    catch (OverflowException)
                    {
                        message = "number too large for a single";
                    }
                }
                else
                    message = "cannot process text";
            }
            else
                message = "no text to process";
            toolStripStatusLabel.Text = message;
        }

        private void processTextButton_Click(object sender, EventArgs e)
        {
            processString(textBox.Text);
        }

        private void processClipboardButton_Click(object sender, EventArgs e)
        {
            processString(Clipboard.GetText());
        }
    }
}
